#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct patient {
    char bloodType[2];
    int requiredUnits;
    int unitsInjected[4];
}Patient;

int stringsMatch(char str1[], char str2[]) {
    int n1 = strlen(str1);
    int n2 = strlen(str2);
    if(n1 != n2) {
        return 0;
    }
    int i;
    for(i = 0; i < n1; i++) {
        if(str1[i] != str2[i]) {
            return 0;
        }
    }
    return 1;
}

int main(int argc, char *argv[]) {

    int n, o, a, b, ab, i, j;

    do {
        printf("N: ");
        scanf("%d", &n);
    } while(n < 0 || n > 10000);

    do {
        printf("Blood reserves: ");
        scanf("%d %d %d %d", &o, &a, &b, &ab);
    } while(o < 0 || o > 1000000 || a < 0 || a > 1000000 || b < 0 || b > 1000000 || ab < 0 || ab > 1000000);

    Patient patients[n];

    for(i = 0; i < n; i++) {
        scanf("%s", patients[i].bloodType);
        do {
            scanf("%d", &patients[i].requiredUnits);
        } while(patients[i].requiredUnits < 0 || patients[i].requiredUnits > 1000000);
        patients[i].unitsInjected[0] = 0;
        patients[i].unitsInjected[1] = 0;
        patients[i].unitsInjected[2] = 0;
        patients[i].unitsInjected[3] = 0;
    }

    for(i = 0; i < n; i++) {
        //O Blood Type
        if(stringsMatch(patients[i].bloodType, "O")) {
            if(o < patients[i].requiredUnits) {
                printf("nemoguce");
                return 0;
            }
            o -= patients[i].requiredUnits;
            patients[i].unitsInjected[0] = patients[i].requiredUnits;
        }
        //A Blood Type
        if(stringsMatch(patients[i].bloodType, "A")) {
            if(o + a < patients[i].requiredUnits) {
                printf("nemoguce");
                return 0;
            }
            if(a >= patients[i].requiredUnits) {
                a -= patients[i].requiredUnits;
                patients[i].unitsInjected[1] = patients[i].requiredUnits;
            } else {
                if(o > a) {
                    patients[i].unitsInjected[1] = a;
                    patients[i].requiredUnits -= a;
                    a = 0;

                    o -= patients[i].requiredUnits;
                    patients[i].unitsInjected[0] = patients[i].requiredUnits;
                } else {
                    patients[i].unitsInjected[0] = o;
                    patients[i].requiredUnits -= o;
                    o = 0;

                    a -= patients[i].requiredUnits;
                    patients[i].unitsInjected[1] = patients[i].requiredUnits;
                }
            }
        }
        //B Blood Type
        if(stringsMatch(patients[i].bloodType, "B")) {
            if(o + b < patients[i].requiredUnits) {
                printf("nemoguce");
                return 0;
            }
            if(b >= patients[i].requiredUnits) {
                b -= patients[i].requiredUnits;
                patients[i].unitsInjected[2] = patients[i].requiredUnits;
            } else {
                if(o > b) {
                    patients[i].unitsInjected[2] = b;
                    patients[i].requiredUnits -= b;
                    b = 0;

                    o -= patients[i].requiredUnits;
                    patients[i].unitsInjected[0] = patients[i].requiredUnits;
                } else {
                    patients[i].unitsInjected[0] = o;
                    patients[i].requiredUnits -= o;
                    o = 0;

                    b -= patients[i].requiredUnits;
                    patients[i].unitsInjected[2] = patients[i].requiredUnits;
                }
            }
        }
        //AB Blood Type
        if(stringsMatch(patients[i].bloodType, "AB")) {
            if(o + b + a + ab < patients[i].requiredUnits) {
                printf("nemoguce");
                return 0;
            }
            if(ab >= patients[i].requiredUnits) {
                ab -= patients[i].requiredUnits;
                patients[i].unitsInjected[3] = patients[i].requiredUnits;
            } else {

                if(ab > 0 && patients[i].requiredUnits > 0) {
                    patients[i].unitsInjected[3] = ab;
                    patients[i].requiredUnits -= ab;
                    ab = 0;
                }
                if(a > b) {
                    if(a > 0 && patients[i].requiredUnits > 0) {
                        patients[i].unitsInjected[1] = a;
                        patients[i].requiredUnits -= a;
                        a = 0;
                    }
                    if(b > 0 && patients[i].requiredUnits > 0) {
                        patients[i].unitsInjected[2] = b;
                        patients[i].requiredUnits -= b;
                        b = 0;
                    }
                } else {
                    if(b > 0 && patients[i].requiredUnits > 0) {
                        patients[i].unitsInjected[2] = b;
                        patients[i].requiredUnits -= b;
                        b = 0;
                    }
                    if(a > 0 && patients[i].requiredUnits > 0) {
                        patients[i].unitsInjected[1] = a;
                        patients[i].requiredUnits -= a;
                        a = 0;
                    }
                }

                if(o > 0 && patients[i].requiredUnits > 0) {
                    patients[i].unitsInjected[0] = o;
                    patients[i].requiredUnits -= o;
                    o = 0;
                }
                if(o < 0 || a < 0 || b < 0 || ab < 0) {
                    printf("nemoguce");
                    return 0;
                }
            }
        }
    }

    printf("\nmoguce\n");
    printf("   O A B AB\n");
    for(i = 0; i < n; i++) {
        printf("%d. ", i + 1);
        for(j = 0; j < 4; j++) {
            printf("%d ", patients[i].unitsInjected[j]);
        }
        printf("\n");
    }

    return 0;

}